from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math

class BoxArena(Arenas.SuperArena):
    "Be careful not to slip on the ice, or you could end up sliding into a wall of spikes."
    name = "DSL Ice Arena"
    preview = "ice/ice_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-16, 16, 20, -20)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/ice/ice_arena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        fmod = 0.015
        degrad = 0.01745

        self.AddStaticCamera("              Overhead", (0, 28, 0), (90*degrad, 180*degrad), degrad*83)
        self.AddStaticCamera("              Static-1", (0, 20, 19), (45*degrad, 180*degrad), degrad*70)
        self.AddStaticCamera("              Static-2", (0, 25, 19), (82*degrad, 180*degrad), degrad*70)

        self.AddWatchCamera("               WatchCam-1", (0, 28, 0), (16, 20, 90*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-1w", (0, 28, 0), (16, 20, 90*degrad, 60*degrad))
        self.AddWatchCamera("               WatchCam-2", (0, 20, -24), (12, 20, 60*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-2w", (0, 20, -23.5), (12, 20, 70*degrad, 55*degrad))
        self.AddWatchCamera("               WatchCam-3", (0, 20, 31.5), (12, 22, 60*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-3w", (0, 20, 31.5), (12, 22, 70*degrad, 55*degrad))
        
        self.players = ()
        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.051,1.83754), (-12.4182,0.051,12.4283), (-12.4182,0.051,1.83754))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-8.17686,0.051,12.4283), (-12.4182,0.051,12.4283))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-12.4182,0.051,12.4283), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.25999,0.051,12.4283), (-2.49123,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (2.25999,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((12.413,0.051,12.4283), (7.93297,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,1.91641), (12.413,0.051,12.4283))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (12.413,0.051,-12.4279), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (12.413,0.051,-12.4279), (12.413,0.051,-1.93329))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (8.17711,0.051,-12.4279), (12.413,0.051,-12.4279))
        self.AddShadowTriangle((-2.26871,0.051,-12.4279), (2.49519,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (-2.26871,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-12.4182,0.051,-12.4279), (-7.93688,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-1.8361), (-12.4182,0.051,-12.4279))
        self.AddShadowTriangle((-2.49123,0.051,9.91855), (-8.17686,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.49519,0.051,-9.92447), (8.17711,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (-10.2877,0.051,-1.8361), (-2.26871,0.051,-9.92447))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (7.93297,0.051,9.91855), (2.25999,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (-2.49123,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (2.25999,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (10.2878,0.051,1.91641), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (10.2878,0.051,-1.93329), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (2.49519,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-7.93688,0.051,-9.92447), (-2.26871,0.051,-9.92447))
        
    def HazardsOn(self, on):
        if on:
            self.SetSubMaterialSound("spikes_display", "metal", 8.0, "Sounds\\hzd_spike_hit2.wav")
            self.AddCollisionLine((10, 20 ), (16, 14 ))
            self.AddCollisionLine((-16, 14 ), (-10, 20 ))
            self.AddCollisionLine((-16, -14 ), (-10, -20 ))
            self.AddCollisionLine((10, -20 ), (16, -14 ))
        #Walls
        self.AddCollisionLine((-16, -20 ), (-16, 20 ))
        self.AddCollisionLine((-16, 20 ), (16, 20 ))
        self.AddCollisionLine((16, 20 ), (-16, 20 ))
        self.AddCollisionLine((-16, 20 ), (-16, -20 ))

        self.AddPOV(0, (0, 0), (1, 2, 3, 4))
        self.AddPOV(1, (-0.2, -14.4), (0,))
        self.AddPOV(2, (0.2, -14.4), (0,))
        self.AddPOV(3, (-0.2, 14.2), (0,))
        self.AddPOV(4, (0.2, 14.2), (0,))

        return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)
        
Arenas.register(BoxArena)
